/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.bridge.request;

import com.ibm.hwmca.fw.bridge.IncomingServiceRequest;
import java.io.IOException;
import java.lang.reflect.Array;

public abstract class ReqGetArrayElement
extends IncomingServiceRequest {
    String objectName;
    int index;
    int length;

    public void readRequest() throws IOException {
        this.objectName = this.in.readUTF();
        this.index = this.in.readInt();
        this.length = this.in.readInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeRequest() throws IOException {
        Object target = this.lookupRegisteredObject(this.objectName);
        if (target == null) {
            return;
        }
        if (!target.getClass().isArray()) {
            this.sendError(13, this.objectName);
            return;
        }
        try {
            Object object = this.getWriteLock();
            synchronized (object) {
                this.readElementsAndReply(target, this.index, this.length);
                this.out.flush();
            }
        }
        catch (IllegalArgumentException e) {
            this.sendError(10, "Array is of type " + target.getClass().getComponentType().getName());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.sendError(14, "Index is " + this.index + ", length is " + this.length + ", array length is " + Array.getLength(target));
        }
    }

    protected abstract void readElementsAndReply(Object var1, int var2, int var3) throws IllegalArgumentException, ArrayIndexOutOfBoundsException, IOException;
}

